define(['underscore', 'marionette'], function (_, Marionette) {
    'use strict';

    return Marionette.View.extend({
        className: 'hidden',
        template: _.template('<p><%- response %></p>'),
        modelEvents: {'change:response': 'render showAriaLiveText'},

        // template initializes with class hidden
        onRender: function() {
            this.showAriaLiveText(this.$el);
        },

        // NDVA/IE9 workaround to read aria live text
        // by toggling .hidden { display: none; }
        showAriaLiveText: function() {
            this.$el.removeClass('hidden');
        },
    });
});
